@isTest
private class DeleteDraftArticlesBatchTest {

    @testSetup
    static void setupData() {
        // 1. Create a list of dummy Draft articles
        List<Knowledge__kav> articles = new List<Knowledge__kav>();
        
        for (Integer i = 0; i < 50; i++) {
            articles.add(new Knowledge__kav(
                Title = 'Test Article ' + i,
                UrlName = 'test-article-' + i,
                Language = 'en_US', // Ensure this matches your org's active language
                Summary = 'This is a test draft article.'
            ));
        }
        
        // 2. Insert them (They automatically become "Draft" status)
        insert articles;
    }

    @isTest
    static void testBatchDelete() {
        // Verify data exists before the batch runs
        Integer countBefore = [SELECT Count() FROM Knowledge__kav WHERE PublishStatus = 'Draft'];
        System.assertEquals(50, countBefore, 'Should start with 50 draft articles.');

        // 3. Run the Batch
        Test.startTest();
        DeleteDraftArticlesBatch batch = new DeleteDraftArticlesBatch();
        Database.executeBatch(batch);
        Test.stopTest(); // This forces the batch to finish immediately

        // 4. Verify they are gone
        Integer countAfter = [SELECT Count() FROM Knowledge__kav WHERE PublishStatus = 'Draft'];
        System.assertEquals(0, countAfter, 'All draft articles should be deleted.');
        
        // Optional: Check if Empty Recycle Bin was called
        // Note: emptyRecycleBin is harder to assert in Unit Tests as standard query behavior 
        // with ALL ROWS can differ in test context, but the logic coverage is key here.
        List<Knowledge__kav> deletedList = [SELECT Id FROM Knowledge__kav WHERE PublishStatus = 'Draft' ALL ROWS];
        System.assertEquals(0, deletedList.size(), 'Recycle bin should be empty in test context.');
    }
}