@isTest
private class PublishDraftArticlesBatchTest {

    @testSetup
    static void setupData() {
        // Create a Draft Knowledge Article
        // Knowledge__kav inserts as 'Draft' by default
        Knowledge__kav k = new Knowledge__kav(
            Title = 'Test Publish Article',
            UrlName = 'test-publish-article-url', 
            Language = 'en_US'
        );
        insert k;
    }

    @isTest
    static void testBatchPublish() {
        // 1. Verify status is 'Draft' before running
        Knowledge__kav draft = [SELECT Id, PublishStatus, KnowledgeArticleId FROM Knowledge__kav WHERE UrlName = 'test-publish-article-url' LIMIT 1];
        System.assertEquals('Draft', draft.PublishStatus, 'Article should start as Draft.');

        // 2. Run the Batch
        Test.startTest();
        PublishDraftArticlesBatch batch = new PublishDraftArticlesBatch();
        Database.executeBatch(batch);
        Test.stopTest();

        // 3. Verify status is now 'Online'
        // IMPORTANT: When an article is published, the specific record ID might change or be versioned,
        // so we query by the Master KnowledgeArticleId to get the current Online version.
        Knowledge__kav onlineVersion = [
            SELECT Id, PublishStatus 
            FROM Knowledge__kav 
            WHERE KnowledgeArticleId = :draft.KnowledgeArticleId 
            AND PublishStatus = 'Online' 
            LIMIT 1
        ];

        System.assertNotEquals(null, onlineVersion, 'An Online version should exist.');
        System.assertEquals('Online', onlineVersion.PublishStatus, 'The status should be Online.');
    }
}