@isTest
private class ArchivePublishArticlesBatchTest {

    @testSetup
    static void setupData() {
        // 1. Create a Draft Knowledge Article
        Knowledge__kav k = new Knowledge__kav(
            Title = 'Test Archive Article',
            UrlName = 'test-archive-article-url', 
            Language = 'en_US'
        );
        insert k;
        
        // 2. Publish it immediately so it becomes 'Online'
        // We need the master KnowledgeArticleId to perform the publish action
        Knowledge__kav draft = [SELECT KnowledgeArticleId FROM Knowledge__kav WHERE Id = :k.Id];
        KbManagement.PublishingService.publishArticle(draft.KnowledgeArticleId, true);
    }

    @isTest
    static void testBatchArchive() {
        // 1. Verify status is 'Online' before running the batch
        Knowledge__kav online = [SELECT Id, PublishStatus, KnowledgeArticleId FROM Knowledge__kav WHERE UrlName = 'test-archive-article-url' AND PublishStatus = 'Online' LIMIT 1];
        System.assertEquals('Online', online.PublishStatus, 'Article must be Online before archiving test.');

        // 2. Run the Batch
        Test.startTest();
        ArchivePublishArticlesBatch batch = new ArchivePublishArticlesBatch();
        Database.executeBatch(batch);
        Test.stopTest();

        // 3. Verify status is now 'Archived'
        // We query by the Master KnowledgeArticleId to find the current Archived version.
        Knowledge__kav archivedVersion = [
            SELECT Id, PublishStatus 
            FROM Knowledge__kav 
            WHERE KnowledgeArticleId = :online.KnowledgeArticleId 
            AND PublishStatus = 'Archived' 
            LIMIT 1
        ];

        System.assertNotEquals(null, archivedVersion, 'An Archived version should exist.');
        System.assertEquals('Archived', archivedVersion.PublishStatus, 'The status should be Archived.');
    }
}