@isTest
private class DraftArchiveArticlesBatchTest {

    @testSetup
    static void setupData() {
        // 1. Create a Draft Knowledge Article
        Knowledge__kav k = new Knowledge__kav(
            Title = 'Test Restore Article',
            UrlName = 'test-restore-article-url', 
            Language = 'en_US'
        );
        insert k;
        
        // 2. Publish it (Draft -> Online)
        Knowledge__kav draft = [SELECT KnowledgeArticleId FROM Knowledge__kav WHERE Id = :k.Id];
        KbManagement.PublishingService.publishArticle(draft.KnowledgeArticleId, true);
        
        // 3. Archive it (Online -> Archived)
        // We must have an archived article for the batch to process
        KbManagement.PublishingService.archiveOnlineArticle(draft.KnowledgeArticleId, null);
    }

    @isTest
    static void testBatchRestore() {
        // 1. Verify status is 'Archived' before running
        Knowledge__kav archived = [SELECT Id, PublishStatus, KnowledgeArticleId FROM Knowledge__kav WHERE UrlName = 'test-restore-article-url' AND PublishStatus = 'Archived' LIMIT 1];
        System.assertEquals('Archived', archived.PublishStatus, 'Article must be Archived before test.');

        // 2. Run the Batch
        Test.startTest();
        DraftArchiveArticlesBatch batch = new DraftArchiveArticlesBatch();
        Database.executeBatch(batch);
        Test.stopTest();

        // 3. Verify a new 'Draft' version exists
        // The editArchivedArticle method creates a NEW version with status 'Draft'
        Knowledge__kav newDraftVersion = [
            SELECT Id, PublishStatus 
            FROM Knowledge__kav 
            WHERE KnowledgeArticleId = :archived.KnowledgeArticleId 
            AND PublishStatus = 'Draft' 
            LIMIT 1
        ];

        System.assertNotEquals(null, newDraftVersion, 'A new Draft version should exist.');
        System.assertEquals('Draft', newDraftVersion.PublishStatus, 'The status should be Draft.');
    }
}